/*****************************************************************************

       Copyright  1995, 1996 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*
 *  Entry point for the Milo stub code.  This code does a few initialising
 *  jobs, unzips Milo and then jumps to it.
 *
 *  david.rusling@reo.mts.dec.com
 */
#include <linux/kernel.h>
#include <linux/config.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/kernel_stat.h>
#include <linux/pci.h>
#include <linux/bios32.h>
#include <linux/version.h>

#include <asm/system.h>
#include <asm/io.h>
#include <asm/console.h>
#include <asm/hwrpb.h>
#include <asm/page.h>
#include <asm/pgtable.h>

#include <stdarg.h>

#include "milo.h"
#include "osfboot.h"
#include "impure.h"
#include "uart.h"
#include "fs.h"
#include "zip/gzip.h"
#include "video.h"
#include "smc.h"

/*
 *  If you turn this on, you'll have to include uart.o, printf.o and so on.
 */
#if 0
#define DEBUG_RELOCATE 1
#endif

/*****************************************************************************
 *  Macros.                                                                  *
 *****************************************************************************/
struct hae hae = {
  0, 
  (unsigned long *) HAE_ADDRESS
  };

struct bootvideo *milo_video = NULL;

extern char flash_image[];
extern unsigned int flash_image_size;

void free(void *where)
{
}

void video_putchar(unsigned char c)
{
}

void boot_main_cont(void) 
{
}

void doinitdata(void) 
{
}

void __panic(void) 
{
}

/*****************************************************************************
 *   Main entry point for system primary bootstrap code                      *
 *****************************************************************************/
unsigned long __main(void) 
{
/*****************************************************************************
 *  Initialize.                                                              *
 *****************************************************************************/
/*
 *  First initialize the Evaulation Board environment.
 */

#ifdef DEBUG_RELOCATE

#if defined(CONFIG_ALPHA_PC164) || defined(CONFIG_ALPHA_LX164)
/*
 *  The PC164 employs the SMC FDC37C93X Ultra I/O Controller.
 *  After reset all of the devices are disabled. SMC93X_Init() will
 *  autodetect the FDC37C93X and enable each of the devices.
 */
    SMC93X_Init();
#endif

    /* we can only output to the serial port *after* we initialise it */
    uart_init();
#endif

#ifdef DEBUG_RELOCATE

    /* announce ourselves */
    printk("Milo Relocate: V1.0\n");
#endif

    /* copy milo into the appropriate place in memory */
#ifdef DEBUG_RELOCATE
    printk("Copying Milo into position at 0x%p\n", (void *) PALCODE_AT);
#endif
    memcpy((void *) PALCODE_AT, (void *) flash_image, flash_image_size);

    /* now jump to it */
#ifdef DEBUG_RELOCATE
    printk("Jumping to Milo...\n");
#endif
    return (unsigned long) PALCODE_AT;
}

